\version "2.24.0"
\language "deutsch"

\paper {
  system-system-spacing = #'((basic-distance . 16))
  markup-system-spacing = #'((basic-distance . 23))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 10\mm
  ragged-last-bottom=##f
  %system-count = #6
}

% diacritice: ă â î ş ţ Ţ Ş Ă

\header {
  title = "Doamne mântuieşte"
  subtitle = "glasul 8"
  composer = "arm. după N. Lungu"
  %meter = "Andante"
  tagline = ""
}

global = {
  \key f \major
  \time 4/4
  \set Staff.midiInstrument = "clarinet"
}

womenWords = \lyricmode {
  Doam -- ne mân -- tu -- ieş -- te pe cei bi -- ne cre -- din -- cioşi.
  Şi __ ne a -- uzi şi ne a -- uzi __ pe __ noi
  şi ne a -- uzi pe __ noi, pe __ noi.
}
menWords = \lyricmode {
  Doam -- ne mân -- tu -- ieş -- te pe cei bi -- ne cre -- din -- cioşi.
  Şi __ ne a -- uzi şi ne a -- uzi pe noi
  şi ne a -- uzi pe noi, __ pe __ noi.
}  

sopMusic = \relative c' {
  %\cadenzaOn
  g'4^\p f e f g4.( a8 g4 a)
  f2 \bar"|" \break
  \partial 1 g4.^\mf b8 a4 g
  f2 e f2 \fermata \bar ":|." \break
  \mark "Şi ne auzi"
  \partial 2 b2\rest
  f8([^\p g f g)]
  a4 b
  c4. \breathe c8^\mf^\<
  d4 e\!
  f2^\f
  es4^\>( d)
  c4.\! b8^\mf
  a4^\> g8( a)
  f2\!
  g8^\p([ a^\< b^\> a)]
  g2\!
  f8^\markup "rall."([^\pp e d e)]
  f2\fermata \bar "|."
}

altMusic = \relative c' {
  g'4 f e f g4.( a8 g4 a) f2
  e4. g8 f4 e d2 e f 
  b2\rest
  f8([ g f g)] f4 g a4. a8 b4 b
  a( c) c( b) a4. g8 f4 e f2
  e8([ f g f]) e2 f8([ e d e)]
  f2  
}

tenorMusic = \relative c' {
  g4 f e f g4.( a8 g4 a) f2
  c'4. c8 c4 c8( b) a2 g f2
  r2 r a4^\markup"Și" b8^\markup "ne a-" b c4.
  c8 b4 b a2 a a4. b8 c4 c c2 c c4( b) a( g) f2  
}

bassMusic = \relative c' {
  g4 f e f g4.( a8 g4 a) f2
  c4. c8 f4 c d2 c f2
  f2( f) f4 f f4. f8 b4 g f2
  f f4. g8 f4 c f2 c c f8([ e d c)] <f f,>2
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      %\new Voice { \global \sopMusic }
      \new Voice { \voiceOne \global \sopMusic }
      \new Voice { \voiceTwo \global \altMusic }
      \addlyrics { \womenWords }
    >>

    \new Staff <<
      \clef bass
      %\new Voice { \global \tenorMusic }
      \new Voice { \voiceOne \global \tenorMusic }
      \new Voice { \voiceTwo \global \bassMusic }
      %\new Voice { \global \bassMusic }
      \addlyrics { \menWords }
    >>
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
    \tempo 4 = 80
    \context { \Voice \remove "Dynamic_performer" }
}

\score {
  %\unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  %\unfoldRepeats
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  %\unfoldRepeats
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}